clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"
	
*** Program to estimate stacked price table

	import delimited "iri_wm_panel_new.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator

	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	
	encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores weekid
	
/*	egen dis = rowtotal(dis*)
	forvalues i=1/19 {
		capture gen dis`i'_2 = dis`i'^2
		capture gen dis`i'_3 = dis`i'^3
		}
	egen dis_sq = rowtotal(dis*_2)
	egen dis_cu = rowtotal(dis*_3)
	drop dis*_2 dis*_3
*/	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores	
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
* Merge in demos
	rename stores iri_key
	merge m:1 iri_key using "store_demos_cat.dta"
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	rename inccymedhh medinc
	rename popcydens density

	by stores, sort: gen n = _n
	foreach var in medinc {
		norm(`var') if n==1, method(zee) by(mkt)
		}
	
	xtile inc = medinc if n==1, nq(5)
	xtile inc_mkt = zee_medinc if n==1, nq(5)
*	xtile dens = density, nq(3)

	foreach var of varlist zee_* inc inc_mkt {
		by stores, sort: egen max = max(`var')
		drop `var'
		rename max `var'
		}
	drop n
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Create variables

	merge m:1 monthid using cpi.dta
	drop _merge
	
	gen logrev = log(foodrev / cpi * 100)

	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen `var'_price = (`var' / `var'_vol_sales) / cpi * 100
		drop `var' `var'_vol_sales
		}
		
	* Fix outlier
	qui sum fzdinent_price, detail
	replace fzdinent_price = . if fzdinent_price > `r(p99)'

	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen logp_vol_`var' = log(`var'_price)
		gen logp_avg_`var' = log(`var'_avg_price / cpi * 100)
		}
		
	compress

keep stores weekid wm wm_* mkt chain* enter logp* firmtype treat_nwm week* inc inc_mkt zee*

** Stack datasets
	
	preserve
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		keep stores weekid wm wm_* mkt chain* enter firmtype logp*_`var' treat_nwm week* inc inc_mkt zee*
		gen category = "`var'"
		rename logp_vol_`var' logp_vol
		rename logp_avg_`var' logp_avg
		save `var'.dta, replace
		restore, preserve
		}
	restore, not
		
	clear
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		append using `var'.dta
		erase `var'.dta
		}
		
	encode category, gen(cat)
	egen storecat = group(stores cat)
	xtset storecat weekid
		
** Regressions
	cd "\Results"
	
	gen wm_lt7 = wm_1+wm_3+wm_5+wm_7
	gen wm_lt5 = wm_1+wm_3+wm_5
	
	* Heterogeneity
	foreach var of varlist logp_vol {
		foreach het in firmtype {		
			reghdfe `var' enter c.wm_lt5#i.`het' i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, a(storecat weekid) cluster(stores) keepsing
				outreg2 using final_het_`het', excel
			}
		}
		
	foreach var of varlist wm wm_lt* {
		gen `var'_n1 = (`var'==1)
		gen `var'_n2 = (`var'==2)
		gen `var'_n3plus = (`var' > 2 & `var' < .)
		}
	
	foreach var of varlist wm_lt5 {
		xtreg logp_vol enter `var' i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, fe i(storecat) cluster(stores)
			outreg2 using final_het_n, excel
		xtreg logp_vol enter `var'_n* i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, fe i(storecat) cluster(stores)
			outreg2 using final_het_n, excel
		}
	
	